/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.features.crystalcragsurface;

import blueduck.outerend.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.impl.Shapes;
import shadow.com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.BendLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.DilateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;

public class VioliteDeadRainbowFeature
extends Feature<NoFeatureConfig> {
    public VioliteDeadRainbowFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextDouble() < 0.3) {
            BlockState VIOLITE = ((Block)BlockRegistry.VIOLITE.get()).func_176223_P();
            List<BlockState> WHITELIST = Arrays.asList(VIOLITE, Blocks.field_150350_a.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
            pos = reader.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos);
            while (reader.func_175623_d(pos.func_177977_b()) && pos.func_177956_o() != 0) {
                pos = pos.func_177977_b();
            }
            if (reader.func_180495_p(pos.func_177977_b()) == VIOLITE) {
                double length = random.nextDouble() * 15.0 + 20.0;
                double radius = random.nextDouble() * 6.0 + 4.0;
                double arc = 80.0 + MathHelper.func_219803_d((double)random.nextDouble(), (double)-10.0, (double)10.0);
                double arc2 = 80.0 + MathHelper.func_219803_d((double)random.nextDouble(), (double)-10.0, (double)10.0);
                double scale = MathHelper.func_219803_d((double)random.nextDouble(), (double)0.7, (double)1.3);
                double downY = random.nextDouble() * (length / 5.0) + 1.0;
                Shape shape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
                double nextArchPos = -new BendLayer(arc, radius, length).modifyMin(shape).getX();
                boolean suitable = false;
                double fullRotation = random.nextDouble() * 360.0;
                BlockPos nextArch = pos.func_177963_a(-Math.cos(Math.toRadians(fullRotation)) * nextArchPos * scale, (double)pos.func_177956_o(), Math.sin(Math.toRadians(fullRotation)) * nextArchPos * scale);
                block1: for (int tries = 0; !suitable && tries <= 360; ++tries) {
                    nextArch = pos.func_177963_a(-Math.cos(Math.toRadians(fullRotation += 1.0)) * nextArchPos * scale, 0.0, Math.sin(Math.toRadians(fullRotation)) * nextArchPos * scale);
                    for (BlockPos boxPos : BlockPos.func_218278_a((BlockPos)nextArch.func_177982_a(0, -3, 0), (BlockPos)nextArch.func_177982_a(0, 3, 0))) {
                        if (suitable) continue block1;
                        suitable = reader.func_180495_p(boxPos).func_203425_a(VIOLITE.func_177230_c());
                    }
                }
                if (suitable) {
                    nextArchPos = (double)(-Math.abs(pos.func_218139_n((Vector3i)nextArch))) + length / 3.0;
                    shape = shape.applyLayer(new AddLayer(Shapes.ellipticalPyramid(radius, radius, length).applyLayer(new BendLayer(arc, radius, length)).applyLayer(new DilateLayer(Position.of(scale, scale, scale)))));
                    shape = shape.applyLayer(new AddLayer(Shapes.ellipticalPyramid(radius, radius, length).applyLayer(new BendLayer(arc2, radius, length)).applyLayer(new RotateLayer(Quaternion.of(0.0, 180.0, 0.0, true))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new TranslateLayer(Position.of(nextArchPos, 0.0, 0.0)))));
                    shape = shape.applyLayer(new RotateLayer(Quaternion.of(0.0, fullRotation, 0.0, true)));
                    shape = shape.applyLayer(new TranslateLayer(Position.of(pos)));
                    shape = shape.applyLayer(new TranslateLayer(Position.of(0.0, -downY, 0.0)));
                    shape.validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, VIOLITE)));
                    return true;
                }
            }
        }
        return false;
    }
}

